package app.firezone.synk.network;

import android.app.ProgressDialog;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.Add_Money_Activity;
import app.firezone.synk.network.databinding.ActivityMatchJoiningBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.JoinedMatchResponse;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.User;
import app.firezone.synk.network.model.UserResponse;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class MatchJoiningActivity extends AppCompatActivity {

    ActivityMatchJoiningBinding binding;

    ArrayList<String> slotsNoList, checkboxNoList;

    int totalChecked;

    long userId;

    String gamename, email, name, m;
    long matchId, entryFee;

    long winBalance, depoBalance, bonusBalance, totalCoin, totalFee, matchPlayed;

    private MyApi myApi;

    ProgressDialog progressDialog;

    long requiredFee;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityMatchJoiningBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        // Receive the data correctly as ArrayList
        slotsNoList = getIntent().getStringArrayListExtra("selectedSlotNumbers");
        checkboxNoList = getIntent().getStringArrayListExtra("selectedPositions");
        totalChecked = getIntent().getIntExtra("totalSelection", 0);
        gamename = getIntent().getStringExtra("gamename");
        entryFee = getIntent().getLongExtra("entryFee", 0);
        matchId = getIntent().getLongExtra("matchId", 0);

        binding.pleaseWaitTxt.setVisibility(View.VISIBLE);
        binding.balanceInfoTxt.setVisibility(View.GONE);
        binding.joinBtn.setVisibility(View.GONE);

        progressDialog = new ProgressDialog(MatchJoiningActivity.this);
        progressDialog.setTitle("Joining Match");
        progressDialog.setMessage("Please Wait.....");
        progressDialog.setCancelable(true);

        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
        userId = SharedPrefManager.getInstance(MatchJoiningActivity.this).getUserId();
        loadUserData();

        // Show only required number of containers and set slot/position
        ConstraintLayout[] teamLayouts = new ConstraintLayout[]{
                binding.team1Layout,
                binding.team2Layout,
                binding.team3Layout,
                binding.team4Layout
        };

        TextView[] teamTexts = new TextView[]{
                binding.teamNo1,
                binding.teamNo2,
                binding.teamNo3,
                binding.teamNo4
        };

        TextView[] posTexts = new TextView[]{
                binding.positionNo1,
                binding.positionNo2,
                binding.positionNo3,
                binding.positionNo4
        };

        for (int i = 0; i < totalChecked; i++) {
            int slotNum = Integer.parseInt(slotsNoList.get(i));
            String pos = checkboxNoList.get(i);

            teamLayouts[i].setVisibility(View.VISIBLE);
            teamTexts[i].setText("Team " + slotNum);
            posTexts[i].setText("" + pos);
        }


        binding.joinBtn.setOnClickListener(v -> {
            String usernameEdt = binding.username1.getText().toString();
            long matchPlayeds = 1;
            long finalPlayed = matchPlayed + matchPlayeds;

            long requiredFee = entryFee * totalChecked;

            if (TextUtils.isEmpty(usernameEdt)) {
                binding.username1.setError("Enter Username");
                Toast.makeText(MatchJoiningActivity.this, "Enter Username", Toast.LENGTH_SHORT).show();
            } else if (usernameEdt.equals("Player 1")) {
                binding.username1.setError("Enter Valid Username");
                Toast.makeText(MatchJoiningActivity.this, "Enter Valid Username", Toast.LENGTH_SHORT).show();
            } else if (requiredFee <= totalCoin) {
                Map<String, Object> map = new HashMap<>();
                map.put("username", usernameEdt);
                map.put("matchPlayed", finalPlayed);

                progressDialog.show();
                Call<UserResponse> call = myApi.updateUser(userId, map);

                call.enqueue(new Callback<UserResponse>() {
                    @Override
                    public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                        progressDialog.dismiss();
                        if (response.isSuccessful() && response.body() != null) {
                            Toast.makeText(MatchJoiningActivity.this, "Match Joined!", Toast.LENGTH_SHORT).show();
                            deductCoin();
                        } else {
                            try {
                                String errorBody = response.errorBody().string();
                                Log.e("API_ERROR", "Error response: " + errorBody);
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                            Toast.makeText(MatchJoiningActivity.this, "Failed to update user data.", Toast.LENGTH_SHORT).show();
                        }
                    }

                    @Override
                    public void onFailure(Call<UserResponse> call, Throwable throwable) {
                        progressDialog.dismiss();
                        throwable.printStackTrace();
                        Log.e("RETROFIT_FAILURE", "Error cause: ", throwable);
                        Toast.makeText(MatchJoiningActivity.this, "Error: " + throwable.getMessage(), Toast.LENGTH_LONG).show();
                    }
                });

            } else {
                Toast.makeText(MatchJoiningActivity.this, "Not enough balance. Redirecting...", Toast.LENGTH_SHORT).show();
                startActivity(new Intent(MatchJoiningActivity.this, Add_Money_Activity.class));
            }
        });


        binding.team1Layout.setOnClickListener(v -> addUsernameDialog(binding.username1));
        binding.team2Layout.setOnClickListener(v -> addUsernameDialog(binding.username2));
        binding.team3Layout.setOnClickListener(v -> addUsernameDialog(binding.username3));
        binding.team4Layout.setOnClickListener(v -> addUsernameDialog(binding.username4));


    }


    private void deductCoin() {
        if (totalFee == 0) {
            saveSoloMatchData(null);
        } else {
            boolean canDeduct = false;
            Map<String, Object> coinMap = new HashMap<>();

            // ✅ SAVE original balances BEFORE deduction
            final Map<String, Object> originalBalance = new HashMap<>();
            originalBalance.put("depoBalance", depoBalance);
            originalBalance.put("bonusBalance", bonusBalance);
            originalBalance.put("winBalance", winBalance);

            if (totalFee <= depoBalance && bonusBalance >= 1) {
                long depoEntry = totalFee - 1;
                long bonusBal = 1;
                long depoBal = depoBalance - depoEntry;
                long bonBal = bonusBalance - bonusBal;

                coinMap.put("depoBalance", depoBal);
                coinMap.put("bonusBalance", bonBal);
                canDeduct = true;
            } else if (totalFee <= depoBalance) {
                long depoBal = depoBalance - totalFee;
                coinMap.put("depoBalance", depoBal);
                canDeduct = true;
            } else if (totalFee <= totalCoin && bonusBalance >= 1) {
                long depoEntry = totalFee - 1;
                long bonusBal = 1;
                long requiredCoin = depoEntry - depoBalance;
                long winCoin = winBalance - requiredCoin;

                coinMap.put("depoBalance", 0L);
                coinMap.put("bonusBalance", bonusBal);
                coinMap.put("winBalance", winCoin);
                canDeduct = true;
            } else if (totalFee <= totalCoin) {
                long requiredCoin = totalFee - depoBalance;
                long winCoin = winBalance - requiredCoin;

                coinMap.put("depoBalance", 0L);
                coinMap.put("winBalance", winCoin);
                canDeduct = true;
            }

            if (canDeduct) {

                MyApi myApi1 = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
                Call<UserResponse> updateCall = myApi1.updateUser(userId, coinMap);

                updateCall.enqueue(new Callback<UserResponse>() {
                    @Override
                    public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                        if (response.isSuccessful() && response.body() != null) {
                            String transactionType =  "Match Fee";
                            saveUsersTransactionDetails(transactionType);
                            saveSoloMatchData(originalBalance); // ✅ Pass original balance for rollback
                        } else {
                            Log.e("DeductCoinError", "Failed to deduct coins. Response: " + response.message());
                            Toast.makeText(MatchJoiningActivity.this, "Failed to deduct coins. Please try again.", Toast.LENGTH_SHORT).show();
                        }
                    }

                    @Override
                    public void onFailure(Call<UserResponse> call, Throwable t) {
                        Log.e("DeductCoinError", "API call failed: " + t.getMessage());
                        Toast.makeText(MatchJoiningActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
                    }
                });
            } else {
                Toast.makeText(this, "Not Enough Money", Toast.LENGTH_SHORT).show();
            }
        }
    }
    private void rollbackCoinDeduction(Map<String, Object> originalCoins) {
        if (originalCoins == null || originalCoins.isEmpty()) return;

        Map<String, Object> rollbackMap = new HashMap<>();

        if (originalCoins.containsKey("depoBalance")) {
            rollbackMap.put("depoBalance", originalCoins.get("depoBalance"));
        }
        if (originalCoins.containsKey("bonusBalance")) {
            rollbackMap.put("bonusBalance", originalCoins.get("bonusBalance"));
        }
        if (originalCoins.containsKey("winBalance")) {
            rollbackMap.put("winBalance", originalCoins.get("winBalance"));
        }


        Call<UserResponse> rollbackCall = myApi.updateUser(userId, rollbackMap);

        rollbackCall.enqueue(new Callback<UserResponse>() {
            @Override
            public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                if (response.isSuccessful()) {
                    //  Toast.makeText(ClassicMatchActivity.this, "Balance reverted successfully.", Toast.LENGTH_SHORT).show();
                    String transactionType =  "Refund";
                    saveUsersTransactionDetails(transactionType);
                } else {
                    Toast.makeText(MatchJoiningActivity.this, "Failed to revert balance.", Toast.LENGTH_SHORT).show();
                }
                progressDialog.dismiss();
            }

            @Override
            public void onFailure(Call<UserResponse> call, Throwable t) {
                Toast.makeText(MatchJoiningActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
                progressDialog.dismiss();
            }
        });
    }

    private void saveSoloMatchData(Map<String, Object> originalCoins) {
        if (gamename == null || matchId <= 0 || userId <= 0) {
            Toast.makeText(this, "Invalid match details. Please try again.", Toast.LENGTH_SHORT).show();
            if (originalCoins != null) {
                rollbackCoinDeduction(originalCoins);
            }
            return;
        }

        String username1Edt = binding.username1.getText().toString();
        String slotText = binding.teamNo1.getText().toString();
        String numberOnly = slotText.replaceAll("[^0-9]", "");
        int slot_no = Integer.parseInt(numberOnly);
        String position = binding.positionNo1.getText().toString();


        Call<JoinedMatchResponse> call = myApi.storeMatchJoinedUser(
                matchId,
                email,
                username1Edt,
                name,
                gamename,
                "Expert",
                "0",
                "0",
                String.valueOf(entryFee),
                userId,
                username1Edt,
                slot_no,
                position
        );

        call.enqueue(new Callback<JoinedMatchResponse>() {
            @Override
            public void onResponse(Call<JoinedMatchResponse> call, Response<JoinedMatchResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (response.body().success) {
                        binding.joinText.setText("Already Joined");
                        binding.joinBtn.setBackgroundResource(R.drawable.btn_false);
                        binding.joinBtn.setClickable(false);
                        Toast.makeText(MatchJoiningActivity.this, "Joined Successfully...", Toast.LENGTH_SHORT).show();
                        handleMatchRegistration();
                    } else {
                        Toast.makeText(MatchJoiningActivity.this, response.body().message, Toast.LENGTH_LONG).show();
                    }
                } else {
                    if (originalCoins != null) {
                        rollbackCoinDeduction(originalCoins);
                    }

                    try {
                        String errorBody = response.errorBody().string();
                        Log.e("JoinMatchError", "Error Response: " + errorBody);
                        Toast.makeText(MatchJoiningActivity.this, "Failed: " + errorBody, Toast.LENGTH_LONG).show();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void onFailure(Call<JoinedMatchResponse> call, Throwable t) {
                Log.e("JoinMatchError", "API call failed: " + t.getMessage());
                if (originalCoins != null) {
                    rollbackCoinDeduction(originalCoins);
                }
                Toast.makeText(MatchJoiningActivity.this, "Failed to join: " + t.getMessage(), Toast.LENGTH_LONG).show();
            }
        });


    }

    private void handleMatchRegistration() {
        // Count the filled username fields
        int playerCount = totalChecked;
        // Check if at least one username is filled
        if (playerCount > 0) {

            if (playerCount == 2) {
                // If 2 players are filled, call joinUsers2
                joinUsers2();
                Toast.makeText(MatchJoiningActivity.this, "Register Duo Match", Toast.LENGTH_SHORT).show();
            } else if (playerCount == 3) {
                // If 3 players are filled, call joinUsers2 and joinUsers3
                joinUsers2(); // Join first player
                joinUsers3(); // Join second player
                Toast.makeText(MatchJoiningActivity.this, "Register Trio Match", Toast.LENGTH_SHORT).show();
            } else if (playerCount == 4) {
                // If 4 players are filled, call joinUsers2, joinUsers3, and joinUsers4
                joinUsers2(); // Join first player
                joinUsers3(); // Join second player
                joinUsers4(); // Join third player
                Toast.makeText(MatchJoiningActivity.this, "Register Squad Match", Toast.LENGTH_SHORT).show();
            }else {
                Toast.makeText(this, "Match Joining Successfully...", Toast.LENGTH_SHORT).show();
                successDialog();
            }
        } else {
            // Show a message if no usernames are filled
            Toast.makeText(MatchJoiningActivity.this, "Please fill in at least one username.", Toast.LENGTH_SHORT).show();
        }

        progressDialog.dismiss();
    }

    private void joinUsers2() {
        String usernameEdt = binding.username2.getText().toString();
        String username1Edt = binding.username1.getText().toString();
        String slotText = binding.teamNo2.getText().toString();
        String numberOnly = slotText.replaceAll("[^0-9]", "");
        int slot_no = Integer.parseInt(numberOnly);
        String position = binding.positionNo2.getText().toString();


        Call<JoinedMatchResponse> call = myApi.storeMatchJoinedUser(
                matchId,
                email,
                usernameEdt,
                name,
                gamename,
                "Expert",
                "0",
                "0",
                String.valueOf(entryFee),
                userId,
                username1Edt,
                slot_no,
                position
        );

        call.enqueue(new Callback<JoinedMatchResponse>() {
            @Override
            public void onResponse(Call<JoinedMatchResponse> call, Response<JoinedMatchResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    progressDialog.dismiss();
                    successDialog();
                    Toast.makeText(MatchJoiningActivity.this, "Player 3rd Joined Successfully.", Toast.LENGTH_LONG).show();
                } else {
                    Toast.makeText(MatchJoiningActivity.this, "Failed to join the match. Please try again.", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<JoinedMatchResponse> call, Throwable t) {
                Toast.makeText(MatchJoiningActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void joinUsers3(){

        String usernameEdt = binding.username3.getText().toString();
        String username1Edt = binding.username1.getText().toString();

        String slotText = binding.teamNo3.getText().toString();
        String numberOnly = slotText.replaceAll("[^0-9]", "");
        int slot_no = Integer.parseInt(numberOnly);
        String position = binding.positionNo3.getText().toString();


        Call<JoinedMatchResponse> call = myApi.storeMatchJoinedUser(
                matchId,
                email,
                usernameEdt,
                name,
                gamename,
                "Expert",
                "0",
                "0",
                String.valueOf(entryFee),
                userId,
                username1Edt,
                slot_no,
                position
        );

        call.enqueue(new Callback<JoinedMatchResponse>() {
            @Override
            public void onResponse(Call<JoinedMatchResponse> call, Response<JoinedMatchResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    progressDialog.dismiss();
                    successDialog();
                    Toast.makeText(MatchJoiningActivity.this, "Player 3rd Joined Successfully.", Toast.LENGTH_LONG).show();
                } else {
                    Toast.makeText(MatchJoiningActivity.this, "Failed to join the match. Please try again.", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<JoinedMatchResponse> call, Throwable t) {
                Toast.makeText(MatchJoiningActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });


    }

    private void joinUsers4(){

        String usernameEdt = binding.username4.getText().toString();
        String username1Edt = binding.username1.getText().toString();
        String slotText = binding.teamNo4.getText().toString();
        String numberOnly = slotText.replaceAll("[^0-9]", "");
        int slot_no = Integer.parseInt(numberOnly);
        String position = binding.positionNo4.getText().toString();

        Call<JoinedMatchResponse> call = myApi.storeMatchJoinedUser(
                matchId,
                email,
                usernameEdt,
                name,
                gamename,
                "Expert",
                "0",
                "0",
                String.valueOf(entryFee),
                userId,
                username1Edt,
                slot_no,
                position

        );

        call.enqueue(new Callback<JoinedMatchResponse>() {
            @Override
            public void onResponse(Call<JoinedMatchResponse> call, Response<JoinedMatchResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    progressDialog.dismiss();
                    successDialog();
                    Toast.makeText(MatchJoiningActivity.this, "Player 3rd Joined Successfully.", Toast.LENGTH_LONG).show();
                } else {
                    Toast.makeText(MatchJoiningActivity.this, "Failed to join the match. Please try again.", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<JoinedMatchResponse> call, Throwable t) {
                Toast.makeText(MatchJoiningActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });


    }

    private void addUsernameDialog(TextView targetTextView) {
        ConstraintLayout constraintLayout = findViewById(R.id.paymentSumConstraint);
        View view = LayoutInflater.from(MatchJoiningActivity.this).inflate(R.layout.item_game_username, constraintLayout, false);

        Button confirmBtn = view.findViewById(R.id.confirmBtn);
        Button cancelBtn = view.findViewById(R.id.cancelBtn);
        EditText username = view.findViewById(R.id.usernameEdt);

        setupUsernameField(username);

        AlertDialog.Builder builder = new AlertDialog.Builder(MatchJoiningActivity.this);
        builder.setView(view);
        final AlertDialog alertDialog = builder.create();

        confirmBtn.setOnClickListener(v -> {
            String gameusername = username.getText().toString().trim();

            if (TextUtils.isEmpty(gameusername)) {
                Toast.makeText(MatchJoiningActivity.this, "Please Enter Username", Toast.LENGTH_SHORT).show();
                username.setError("Username Required");
            } else {
                targetTextView.setText(gameusername);  // 👈 Set entered username to correct EditText
                alertDialog.dismiss();
            }
        });

        cancelBtn.setOnClickListener(v -> alertDialog.dismiss());

        if (alertDialog.getWindow() != null) {
            alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable());
        }

        alertDialog.show();
    }


    private void successDialog() {
        ConstraintLayout constraintLayout = findViewById(R.id.successConstraint);
        View view = LayoutInflater.from(MatchJoiningActivity.this).inflate(R.layout.joining_dialog, constraintLayout, false);

        Button confirmBtn = view.findViewById(R.id.btnBackHome);


        AlertDialog.Builder builder = new AlertDialog.Builder(MatchJoiningActivity.this);
        builder.setView(view);
        final AlertDialog alertDialog = builder.create();

        confirmBtn.setOnClickListener(v -> {
            Intent intent = new Intent(MatchJoiningActivity.this, MainActivity.class);
            startActivity(intent);
            finish();
        });

        if (alertDialog.getWindow() != null) {
            alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable());
        }

        alertDialog.show();
    }

    private void setupUsernameField(EditText editText) {
        // TextWatcher to prevent spaces in the username
        editText.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                // No action needed
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                // Remove spaces from the username input
                String input = s.toString().replace(" ", "");
                if (!input.equals(s.toString())) {
                    editText.setText(input);
                    editText.setSelection(input.length()); // Move cursor to the end
                }
            }

            @Override
            public void afterTextChanged(Editable s) {
                // No action needed
            }
        });

        // OnKeyListener to prevent Enter key
        editText.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == KeyEvent.ACTION_DOWN && keyCode == KeyEvent.KEYCODE_ENTER) {
                    return true; // Consume the event, preventing Enter from being registered
                }
                return false;
            }
        });

    }

    private void saveUsersTransactionDetails(String type) {
        // Get user details
        long userIdLong = SharedPrefManager.getInstance(this).getUserId();
        String userId = String.valueOf(userIdLong); // Convert to String for API call
        String date = new SimpleDateFormat("dd-MM-yy", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String time = new SimpleDateFormat("HH:mm:ss", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String transactionId = "TRAN" + System.currentTimeMillis();
        String inputCoin = String.valueOf(totalFee);

        // Initialize API Client

        Call<TransactionModel> call = myApi.storeUserTransaction(
                userId,
                type, // type
                email,
                inputCoin, // amount
                date,
                time,
                transactionId,
                "Wallet", // method
                "Success" // status
        );

        call.enqueue(new Callback<TransactionModel>() {
            @Override
            public void onResponse(Call<TransactionModel> call, Response<TransactionModel> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText(MatchJoiningActivity.this, "Transaction Successfully", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(MatchJoiningActivity.this, "Failed to Record Transaction: " + response.message(), Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<TransactionModel> call, Throwable throwable) {
                Toast.makeText(MatchJoiningActivity.this, "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void loadUserData() {
        if (userId <= 0) {
            Toast.makeText(this, "Invalid user ID", Toast.LENGTH_SHORT).show();
            return;
        }
        Call<ApiResponse> call = myApi.fetchProfileData(userId);
        call.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = response.body().getUser();
                    binding.pleaseWaitTxt.setVisibility(View.GONE);
                    binding.balanceInfoTxt.setVisibility(View.VISIBLE);
                    binding.joinBtn.setVisibility(View.VISIBLE);

                    binding.depoBalance.setText(String.valueOf("₹" + model.getDepoBalance()));
                    binding.winBalance.setText(String.valueOf("₹" + model.getWinBalance()));
                    binding.bonusBalance.setText(String.valueOf("₹" + model.getBonusBalance()));

                    long totalBal = model.getDepoBalance() + model.getWinBalance() + model.getBonusBalance();
                    binding.totalBalance.setText(String.valueOf("₹" + totalBal));

                    winBalance = model.getWinBalance();
                    depoBalance = model.getDepoBalance();
                    bonusBalance = model.getBonusBalance();

                    email = model.getEmail();
                    name = model.getName();

                    matchPlayed = model.getMatchPlayed();

                    totalCoin = model.getDepoBalance() + model.getWinBalance();

                    requiredFee = entryFee * totalChecked;
                    totalFee = entryFee * totalChecked;

                    binding.entryFee.setText(String.valueOf("₹" +entryFee));
                    binding.totalFee.setText(String.valueOf("₹" +totalFee));

                    if (requiredFee <= totalCoin) {
                        binding.joinText.setText("Join Now");
                        binding.joinBtn.setCardBackgroundColor(getColor(R.color.primary_color));
                    } else {
                        binding.joinText.setText("Add Money");
                        binding.balanceInfoTxt.setText("You Don't have sufficient PlayCoin");
                        binding.balanceInfoTxt.setTextColor(getColor(R.color.red));
                        binding.joinBtn.setCardBackgroundColor(getColor(R.color.dark_blue));
                    }

                } else {
                    Toast.makeText(MatchJoiningActivity.this, "Failed to fetch user data", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable throwable) {

            }
        });
    }
}